﻿/*
 * JumpCursor_RightByFrame.cs
 * --------------------------------------------------------------------------------
 * 作者          ：あつし（TRY VEGAS Pro）
 * 配布元        ：https://www.try-vegaspro.com/
 * スクリプト概要：指定したフレーム数だけ、再生ヘッドを右にジャンプさせます。
 * 初期設定      ：5フレーム ※スクリプト内の定数(framesToMove)を変更することで調整可能
 * 備考          ：無断転載・再配布・販売・転売は禁止
 * ---------------------------------------------------------------------------------
 */

using System;
using ScriptPortal.Vegas;
using System.Windows.Forms;

public class EntryPoint
{
    public void FromVegas(Vegas vegas)
    {
        // --- 設定 ---
        const long framesToMove = 5;
        // --- 設定ここまで ---
        
        try
        {
            Timecode currentCursorPosition = vegas.Transport.CursorPosition;
            double currentMillis = currentCursorPosition.ToMilliseconds();

            double frameRate = vegas.Project.Video.FrameRate; 
            double frameDuration = 1000.0 / frameRate;

            long alignedFrames = (long)Math.Round(currentMillis / frameDuration);
            long newFrames = alignedFrames + framesToMove;

            double newMillis = newFrames * frameDuration;
            vegas.Transport.CursorPosition = Timecode.FromMilliseconds(newMillis); 
        }
        catch (Exception e)
        {
            MessageBox.Show("スクリプトの実行中にエラーが発生しました:\n" + e.Message,
                            "スクリプトエラー",
                            MessageBoxButtons.OK,
                            MessageBoxIcon.Error);
        }
    }
}