/*
 * JumpAllEdges_Next.cs
 * --------------------------------------------------------------------------------
 *           FiTRY VEGAS Proj
 * zz        Fhttps://www.try-vegaspro.com/
 * XNvgTvFJ[\ʒuE߂̃CxgGbWi[jփJ[\Wv
 *                 SCxgΏہiSgbÑCxgGbWoj
 * o[W    FJumpAllEdges 1.0
 * l          Ff]ځEĔzzE̔E]͋֎~
 * ---------------------------------------------------------------------------------
 */

using System;
using System.Collections.Generic;
using ScriptPortal.Vegas;
using System.Windows.Forms;

public class EntryPoint
{
    public void FromVegas(Vegas vegas)
    {
        try
        {
            Timecode cursor = vegas.Transport.CursorPosition;
            Timecode nearestEdge = null;

            foreach (Track track in vegas.Project.Tracks)
            {
                foreach (TrackEvent ev in track.Events)
                {
                    if (nearestEdge != null && ev.Start >= nearestEdge)
                    {
                        break;
                    }			
                    UpdateNearest(cursor, ev.Start, ref nearestEdge);
                    UpdateNearest(cursor, ev.End, ref nearestEdge);
                }
            }

            if (nearestEdge != null)
            {
                vegas.Transport.CursorPosition = nearestEdge;
                vegas.Transport.ViewCursor(false);
            }
        }
        catch (Exception e)
        {
		MessageBox.Show("G[܂:\n" + e.Message,"EWvsG[",MessageBoxButtons.OK,MessageBoxIcon.Error);
	}
    }

    private void UpdateNearest(Timecode cursor, Timecode edge, ref Timecode nearestEdge)
    {
        if (edge > cursor)
        {
            if (nearestEdge == null || edge < nearestEdge)
            {
                nearestEdge = edge;
            }
        }
    }
}