/*
 * JumpAllEdges_Prev.cs
 * --------------------------------------------------------------------------------
 *           FiTRY VEGAS Proj
 * zz        Fhttps://www.try-vegaspro.com/
 * XNvgTvFJ[\ʒu獶߂̃CxgGbWi[jփJ[\Wv
 *                 SCxgΏہiSgbÑCxgGbWoj
 * o[W    FJumpAllEdges 1.0
 * l          Ff]ځEĔzzE̔E]͋֎~
 * ---------------------------------------------------------------------------------
 */

using System;
using ScriptPortal.Vegas;
using System.Windows.Forms;

public class EntryPoint
{
    public void FromVegas(Vegas vegas)
    {
        try
        {
            Timecode cursor = vegas.Transport.CursorPosition;
            
	    if (cursor.ToMilliseconds() <= 0) 
	    {
	        return;
	    }
            
            Timecode nearestEdge = null;

            foreach (Track track in vegas.Project.Tracks)
            {
                foreach (TrackEvent ev in track.Events)
                {
			
		    if (ev.Start >= cursor && ev.End >= cursor)
		    {
		    	break; 
		    }			
		
                    UpdateNearest(cursor, ev.Start, ref nearestEdge);
                    UpdateNearest(cursor, ev.End, ref nearestEdge);
                }
            }

            if (nearestEdge != null)
            {
                vegas.Transport.CursorPosition = nearestEdge;
            }
            else
            {
                vegas.Transport.CursorPosition = Timecode.FromMilliseconds(0);
            }

            vegas.Transport.ViewCursor(false);
        }
        catch (Exception e)
        {
		MessageBox.Show("G[܂:\n" + e.Message,"WvsG[",MessageBoxButtons.OK,MessageBoxIcon.Error);

        }
    }

    private void UpdateNearest(Timecode cursor, Timecode edge, ref Timecode nearestEdge)
    {
        if (edge < cursor)
        {
            if (nearestEdge == null || edge > nearestEdge)
            {
                nearestEdge = edge;
            }
        }
    }
}